/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support.aop;

import cn.crane4j.annotation.ArgAutoOperate;
import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.springboot.support.MethodAnnotatedElementAutoOperateSupport;
import cn.crane4j.springboot.support.MethodBaseExpressionEvaluator;
import cn.crane4j.springboot.util.MethodUtils;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;

@Aspect
public class MethodArgumentAutoOperateAspect
extends MethodAnnotatedElementAutoOperateSupport
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MethodArgumentAutoOperateAspect.class);
    private static final MethodAnnotatedElementAutoOperateSupport.ResolvedElement[] EMPTY_ELEMENTS = new MethodAnnotatedElementAutoOperateSupport.ResolvedElement[0];
    private final Map<String, MethodAnnotatedElementAutoOperateSupport.ResolvedElement[]> methodParameterCaches = CollectionUtils.newWeakConcurrentMap();
    private final ParameterNameDiscoverer parameterNameDiscoverer;

    public MethodArgumentAutoOperateAspect(Crane4jGlobalConfiguration configuration, MethodBaseExpressionEvaluator methodBaseExpressionEvaluator, ParameterNameDiscoverer parameterNameDiscoverer) {
        super(configuration, methodBaseExpressionEvaluator);
        this.parameterNameDiscoverer = parameterNameDiscoverer;
        log.info("enable automatic filling of method argument");
    }

    @Before(value="@annotation(cn.crane4j.annotation.ArgAutoOperate)")
    public void before(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ArgAutoOperate annotation = (ArgAutoOperate)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ArgAutoOperate.class);
        if (Objects.isNull(annotation)) {
            return;
        }
        Object[] args = joinPoint.getArgs();
        if (ArrayUtil.isEmpty((Object[])args)) {
            return;
        }
        MethodAnnotatedElementAutoOperateSupport.ResolvedElement[] elements = (MethodAnnotatedElementAutoOperateSupport.ResolvedElement[])MapUtil.computeIfAbsent(this.methodParameterCaches, (Object)method.getName(), name -> this.resolveParameters(annotation, method));
        if (elements == EMPTY_ELEMENTS) {
            return;
        }
        log.debug("process arguments for [{}]", (Object)method.getName());
        this.processArguments(method, args, elements);
    }

    private void processArguments(Method method, Object[] args, MethodAnnotatedElementAutoOperateSupport.ResolvedElement[] resolvedElements) {
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            MethodAnnotatedElementAutoOperateSupport.ResolvedElement element = resolvedElements[i];
            try {
                element.execute(arg);
                continue;
            }
            catch (Exception e) {
                log.warn("cannot process argument [{}] for [{}]: [{}]", new Object[]{method.getName(), ((Parameter)element.getElement()).getName(), ExceptionUtil.getRootCause((Throwable)e).getMessage()});
                e.printStackTrace();
            }
        }
    }

    private MethodAnnotatedElementAutoOperateSupport.ResolvedElement[] resolveParameters(ArgAutoOperate argAutoOperate, Method method) {
        Map<String, Parameter> parameterMap = MethodUtils.resolveParameterNames(this.parameterNameDiscoverer, method);
        Map methodLevelAnnotations = Stream.of(argAutoOperate.value()).collect(Collectors.toMap(AutoOperate::value, Function.identity()));
        MethodAnnotatedElementAutoOperateSupport.ResolvedElement[] results = new MethodAnnotatedElementAutoOperateSupport.ResolvedElement[parameterMap.size()];
        int index = 0;
        for (Map.Entry<String, Parameter> entry : parameterMap.entrySet()) {
            String paramName = entry.getKey();
            Parameter param = entry.getValue();
            AutoOperate annotation = (AutoOperate)Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)param, AutoOperate.class)).orElse((Annotation)methodLevelAnnotations.get(paramName));
            MethodAnnotatedElementAutoOperateSupport.ResolvedElement element = Objects.isNull(annotation) ? EmptyElement.INSTANCE : this.resolveElement(param, annotation);
            results[index++] = element;
        }
        return results;
    }

    public void destroy() {
        for (Object[] objectArray : this.methodParameterCaches.values()) {
            Arrays.fill(objectArray, null);
        }
        this.methodParameterCaches.clear();
    }

    protected static class EmptyElement
    extends MethodAnnotatedElementAutoOperateSupport.ResolvedElement {
        protected static final MethodAnnotatedElementAutoOperateSupport.ResolvedElement INSTANCE = new EmptyElement();

        public EmptyElement() {
            super(null, null, null, null, null);
        }

        @Override
        public void execute(Object result) {
        }
    }
}

