/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support;

import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.KeyTriggerOperation;
import cn.crane4j.core.support.Grouped;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.util.CollectionUtils;
import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class OperateTemplate {
    private final BeanOperationParser defaultParser;
    private final BeanOperationExecutor defaultExecutor;
    private final TypeResolver typeResolver;

    public void executeIfMatchAnyGroups(Object target, String ... groups) {
        this.execute(target, Grouped.anyMatch((String[])groups));
    }

    public void executeIfNoneMatchAnyGroups(Object target, String ... groups) {
        this.execute(target, Grouped.anyMatch((String[])groups).negate());
    }

    public void executeIfMatchAllGroups(Object target, String ... groups) {
        this.execute(target, Grouped.allMatch((String[])groups));
    }

    public void execute(Object target) {
        this.execute(CollectionUtils.adaptObjectToCollection((Object)target), this.resolveType(target), this.defaultParser, this.defaultExecutor, Grouped.alwaysMatch());
    }

    public void execute(Object target, Predicate<? super KeyTriggerOperation> filter) {
        this.execute(CollectionUtils.adaptObjectToCollection((Object)target), this.resolveType(target), this.defaultParser, this.defaultExecutor, filter);
    }

    public void execute(Object target, BeanOperationExecutor executor, Predicate<? super KeyTriggerOperation> filter) {
        this.execute(CollectionUtils.adaptObjectToCollection((Object)target), this.resolveType(target), this.defaultParser, executor, filter);
    }

    public void execute(Collection<?> targets, Class<?> targetType) {
        this.execute(targets, targetType, this.defaultParser, this.defaultExecutor, Grouped.alwaysMatch());
    }

    public void execute(Collection<?> targets, Class<?> targetType, BeanOperationParser parser, BeanOperationExecutor executor, Predicate<? super KeyTriggerOperation> filter) {
        if (CollUtil.isEmpty(targets)) {
            return;
        }
        Objects.requireNonNull(targetType);
        Objects.requireNonNull(parser);
        Objects.requireNonNull(executor);
        BeanOperations beanOperations = parser.parse(targetType);
        executor.execute(targets, beanOperations, filter);
    }

    private <T> Class<T> resolveType(Object target) {
        Class type = this.typeResolver.resolve(target);
        Objects.requireNonNull(type, "cannot resolve type for targets");
        return type;
    }

    public OperateTemplate(BeanOperationParser defaultParser, BeanOperationExecutor defaultExecutor, TypeResolver typeResolver) {
        this.defaultParser = defaultParser;
        this.defaultExecutor = defaultExecutor;
        this.typeResolver = typeResolver;
    }
}

