/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support;

import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.StringValueResolver;

public class MethodBaseExpressionEvaluator
implements EmbeddedValueResolverAware {
    public static final String RESULT = "result";
    private final ParameterNameDiscoverer parameterNameDiscoverer;
    private final ExpressionEvaluator expressionEvaluator;
    private final Function<Method, ExpressionContext> contextFactory;
    private StringValueResolver resolver;

    public <T> @Nullable T execute(String expression, Class<T> resultType, MethodExecution execution) {
        ExpressionContext context = this.resolveContext(execution);
        if (Objects.nonNull(this.resolver)) {
            expression = this.resolver.resolveStringValue(expression);
        }
        return (T)this.expressionEvaluator.execute(expression, resultType, context);
    }

    protected ExpressionContext resolveContext(MethodExecution methodExecution) {
        ExpressionContext context = this.contextFactory.apply(methodExecution.getMethod());
        this.registerParams(methodExecution, context);
        context.registerVariable(RESULT, methodExecution.getResult());
        return context;
    }

    protected void registerParams(MethodExecution methodExecution, ExpressionContext context) {
        String[] paramNames = this.parameterNameDiscoverer.getParameterNames(methodExecution.getMethod());
        Object[] args = methodExecution.getArgs();
        Map<String, Object> paramsMap = this.resolvedParams(paramNames, args);
        paramsMap.forEach((arg_0, arg_1) -> ((ExpressionContext)context).registerVariable(arg_0, arg_1));
    }

    protected Map<String, Object> resolvedParams(String[] paramNames, Object[] args) {
        if (ArrayUtil.isEmpty((Object[])paramNames)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>(paramNames.length);
        int argCount = args.length;
        for (int i = 0; i < paramNames.length; ++i) {
            String name = paramNames[i];
            Object arg = i < argCount ? args[i] : null;
            results.put(name, arg);
        }
        return results;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.resolver = resolver;
    }

    public MethodBaseExpressionEvaluator(ParameterNameDiscoverer parameterNameDiscoverer, ExpressionEvaluator expressionEvaluator, Function<Method, ExpressionContext> contextFactory) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
        this.expressionEvaluator = expressionEvaluator;
        this.contextFactory = contextFactory;
    }

    public static class MethodExecution {
        private final Object[] args;
        private final Method method;
        private final Object result;

        public Object[] getArgs() {
            return this.args;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getResult() {
            return this.result;
        }

        public MethodExecution(Object[] args, Method method, Object result) {
            this.args = args;
            this.method = method;
            this.result = result;
        }
    }
}

