/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.KeyTriggerOperation;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.springboot.support.MethodBaseExpressionEvaluator;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MethodAnnotatedElementAutoOperateSupport {
    private final Crane4jGlobalConfiguration configuration;
    private final MethodBaseExpressionEvaluator methodBaseExpressionEvaluator;

    public boolean checkSupport(Object[] args, Object result, Method method, String condition) {
        if (CharSequenceUtil.isEmpty((CharSequence)condition)) {
            return true;
        }
        MethodBaseExpressionEvaluator.MethodExecution methodContext = new MethodBaseExpressionEvaluator.MethodExecution(args, method, result);
        Boolean support = this.methodBaseExpressionEvaluator.execute(condition, Boolean.class, methodContext);
        return Objects.equals(Boolean.TRUE, support);
    }

    public ResolvedElement resolveElement(AnnotatedElement element, AutoOperate annotation) {
        MethodInvoker extractor = this.resolveExtractor(element, annotation);
        BeanOperationParser parser = ConfigurationUtil.getParser((Crane4jGlobalConfiguration)this.configuration, (String)annotation.parserName(), (Class)annotation.parser());
        BeanOperations beanOperations = parser.parse(annotation.type());
        BeanOperationExecutor executor = ConfigurationUtil.getOperationExecutor((Crane4jGlobalConfiguration)this.configuration, (String)annotation.executorName(), (Class)annotation.executor());
        Set<String> groups = MethodAnnotatedElementAutoOperateSupport.resolveGroups(annotation);
        return new ResolvedElement(element, extractor, groups, beanOperations, executor);
    }

    private MethodInvoker resolveExtractor(AnnotatedElement element, AutoOperate annotation) {
        Class<?> type = MethodAnnotatedElementAutoOperateSupport.resolveTypeForExtractor(element);
        String on = annotation.on();
        MethodInvoker extractor = (t, args) -> t;
        if (CharSequenceUtil.isNotEmpty((CharSequence)on)) {
            PropertyOperator propertyOperator = this.configuration.getPropertyOperator();
            extractor = propertyOperator.findGetter(type, on);
            Objects.requireNonNull(extractor, () -> CharSequenceUtil.format((CharSequence)"cannot find getter for [{}] on [{}]", (Object[])new Object[]{on, annotation.type()}));
        }
        return extractor;
    }

    private static Class<?> resolveTypeForExtractor(AnnotatedElement element) {
        if (element instanceof Method) {
            return ((Method)element).getReturnType();
        }
        if (element instanceof Parameter) {
            return ((Parameter)element).getType();
        }
        throw new IllegalArgumentException("element must be a method or parameter");
    }

    protected static Set<String> resolveGroups(AutoOperate annotation) {
        String[] includes = annotation.includes();
        String[] excludes = annotation.excludes();
        return Stream.of(includes).filter(in -> !ArrayUtil.contains((Object[])excludes, (Object)in)).collect(Collectors.toSet());
    }

    public MethodAnnotatedElementAutoOperateSupport(Crane4jGlobalConfiguration configuration, MethodBaseExpressionEvaluator methodBaseExpressionEvaluator) {
        this.configuration = configuration;
        this.methodBaseExpressionEvaluator = methodBaseExpressionEvaluator;
    }

    public static class ResolvedElement {
        private final AnnotatedElement element;
        private final MethodInvoker extractor;
        private final Set<String> groups;
        private final BeanOperations beanOperations;
        private final BeanOperationExecutor executor;

        public void execute(Object data) {
            Object target = this.extractor.invoke(data, new Object[0]);
            if (Objects.nonNull(target)) {
                Predicate<KeyTriggerOperation> filter = this.groups.isEmpty() ? op -> true : op -> this.groups.contains(op.getKey());
                this.executor.execute(CollectionUtils.adaptObjectToCollection((Object)target), this.beanOperations, filter);
            }
        }

        public AnnotatedElement getElement() {
            return this.element;
        }

        public MethodInvoker getExtractor() {
            return this.extractor;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public BeanOperations getBeanOperations() {
            return this.beanOperations;
        }

        public BeanOperationExecutor getExecutor() {
            return this.executor;
        }

        public ResolvedElement(AnnotatedElement element, MethodInvoker extractor, Set<String> groups, BeanOperations beanOperations, BeanOperationExecutor executor) {
            this.element = element;
            this.extractor = extractor;
            this.groups = groups;
            this.beanOperations = beanOperations;
            this.executor = executor;
        }
    }
}

