/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.callback.ContainerRegisterAware;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.hutool.core.lang.Assert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;

public class Crane4jApplicationContext
implements Crane4jGlobalConfiguration,
SmartInitializingSingleton,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(Crane4jApplicationContext.class);
    private final ApplicationContext applicationContext;
    private final Map<String, Container<?>> registeredContainers = new ConcurrentHashMap();
    private final List<ContainerRegisterAware> containerRegisterAwareList;

    public void addContainerRegisterAware(ContainerRegisterAware containerRegisterAware) {
        this.containerRegisterAwareList.remove(containerRegisterAware);
        this.containerRegisterAwareList.add(containerRegisterAware);
    }

    public boolean containsContainer(String namespace) {
        return this.registeredContainers.containsKey(namespace) || this.applicationContext.containsBean(namespace);
    }

    @Nullable
    public Container<?> replaceContainer(String namespace, UnaryOperator<Container<?>> replacer) {
        Container<?> prev = this.registeredContainers.remove(namespace);
        Container next = (Container)replacer.apply(prev);
        if (Objects.nonNull(next)) {
            this.registeredContainers.put(namespace, next);
        }
        return prev;
    }

    public PropertyOperator getPropertyOperator() {
        return (PropertyOperator)this.applicationContext.getBean(PropertyOperator.class);
    }

    public TypeResolver getTypeResolver() {
        return (TypeResolver)this.applicationContext.getBean(TypeResolver.class);
    }

    public ContainerProvider getContainerProvider(Class<? extends ContainerProvider> providerType) {
        return (ContainerProvider)this.applicationContext.getBean(providerType);
    }

    public ContainerProvider getContainerProvider(String providerName) {
        return (ContainerProvider)this.applicationContext.getBean(providerName, ContainerProvider.class);
    }

    public Container<?> getContainer(String namespace) {
        Container container = this.registeredContainers.get(namespace);
        if (Objects.isNull(container)) {
            container = (Container)this.applicationContext.getBean(namespace, Container.class);
        }
        return (Container)Assert.notNull(container, () -> new Crane4jException("cannot find container [{}]", new Object[]{namespace}));
    }

    public BeanOperationExecutor getBeanOperationExecutor(Class<? extends BeanOperationExecutor> executorType) {
        return (BeanOperationExecutor)this.applicationContext.getBean(executorType);
    }

    public BeanOperationExecutor getBeanOperationExecutor(String executorName) {
        return (BeanOperationExecutor)this.applicationContext.getBean(executorName, BeanOperationExecutor.class);
    }

    public BeanOperationParser getBeanOperationsParser(Class<? extends BeanOperationParser> parserType) {
        return (BeanOperationParser)this.applicationContext.getBean(parserType);
    }

    public BeanOperationParser getBeanOperationsParser(String parserName) {
        return (BeanOperationParser)this.applicationContext.getBean(parserName, BeanOperationParser.class);
    }

    public AssembleOperationHandler getAssembleOperationHandler(Class<? extends AssembleOperationHandler> handlerType) {
        return (AssembleOperationHandler)this.applicationContext.getBean(handlerType);
    }

    public AssembleOperationHandler getAssembleOperationHandler(String handlerName) {
        return (AssembleOperationHandler)this.applicationContext.getBean(handlerName, AssembleOperationHandler.class);
    }

    public DisassembleOperationHandler getDisassembleOperationHandler(Class<? extends DisassembleOperationHandler> handlerType) {
        return (DisassembleOperationHandler)this.applicationContext.getBean(handlerType);
    }

    public DisassembleOperationHandler getDisassembleOperationHandler(String handlerName) {
        return (DisassembleOperationHandler)this.applicationContext.getBean(handlerName, DisassembleOperationHandler.class);
    }

    public void registerContainer(Container<?> container) {
        ConfigurationUtil.registerContainer((Object)this, this.registeredContainers::get, c -> this.registeredContainers.put(c.getNamespace(), (Container<?>)c), container, (Collection)this.getContainerRegisterAwareList());
    }

    public void afterSingletonsInstantiated() {
        this.applicationContext.getBeansOfType(Container.class).values().forEach(this::registerContainer);
    }

    public void destroy() {
        log.info("global configuration has been destroyed.");
        this.registeredContainers.clear();
    }

    public Crane4jApplicationContext(ApplicationContext applicationContext, List<ContainerRegisterAware> containerRegisterAwareList) {
        this.applicationContext = applicationContext;
        this.containerRegisterAwareList = containerRegisterAwareList;
    }

    protected Map<String, Container<?>> getRegisteredContainers() {
        return this.registeredContainers;
    }

    public List<ContainerRegisterAware> getContainerRegisterAwareList() {
        return this.containerRegisterAwareList;
    }
}

