/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support;

import cn.crane4j.annotation.Bind;
import cn.crane4j.annotation.ContainerMethod;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.MethodContainerFactory;
import cn.crane4j.core.support.Sorted;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.springboot.support.AbstractAnnotatedMethodPostProcessor;
import cn.crane4j.springboot.support.Crane4jApplicationContext;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.util.ReflectionUtils;

@Order
public class AnnotationMethodContainerProcessor
extends AbstractAnnotatedMethodPostProcessor<ContainerMethod> {
    private static final Logger log = LoggerFactory.getLogger(AnnotationMethodContainerProcessor.class);
    protected final Collection<MethodContainerFactory> factories;
    protected final Crane4jApplicationContext configuration;

    public AnnotationMethodContainerProcessor(Collection<MethodContainerFactory> factories, Crane4jApplicationContext configuration) {
        super(ContainerMethod.class);
        this.factories = factories.stream().sorted(Comparator.comparing(Sorted::getSort)).collect(Collectors.toList());
        this.configuration = configuration;
    }

    @Override
    protected void processAnnotatedMethods(Object bean, Class<?> beanType, Multimap<Method, ContainerMethod> annotatedMethods) {
        Collection containers = annotatedMethods.keys().stream().map(method -> this.createMethodContainer(bean, (Method)method)).filter(CollUtil::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
        containers.forEach(this.configuration::registerContainer);
    }

    @Override
    @Nullable
    protected Method findMethodForAnnotation(Class<?> beanType, ContainerMethod classLevelAnnotation) {
        Bind bind = classLevelAnnotation.bind();
        String methodName = CharSequenceUtil.emptyToDefault((CharSequence)bind.value(), (String)classLevelAnnotation.namespace());
        Class[] paramTypes = bind.paramTypes();
        Method method = ReflectionUtils.findMethod(beanType, (String)methodName, (Class[])paramTypes);
        Assert.notNull((Object)method, (String)"method cannot be bind to annotation: [{}]", (Object[])new Object[]{bind});
        ReflectUtils.putAnnotation((Annotation)classLevelAnnotation, (Method)method);
        return method;
    }

    private Collection<Container<Object>> createMethodContainer(Object bean, Method method) {
        return this.factories.stream().filter(factory -> factory.support(bean, method)).findFirst().map(factory -> factory.get(bean, method)).orElse(Collections.emptyList());
    }
}

