/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support;

import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;

public abstract class AbstractAnnotatedMethodPostProcessor<T extends Annotation>
implements BeanPostProcessor,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractAnnotatedMethodPostProcessor.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    protected final Class<T> annotationType;

    public void destroy() {
        this.nonAnnotatedClasses.clear();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanType = AopUtils.getTargetClass((Object)bean);
        if (this.nonAnnotatedClasses.contains(beanType)) {
            return bean;
        }
        HashMultimap annotatedMethods = HashMultimap.create();
        this.resolveClassLevelAnnotations(beanType, (Multimap<Method, T>)annotatedMethods);
        this.resolveMethodLevelAnnotations(beanType, (Multimap<Method, T>)annotatedMethods);
        if (annotatedMethods.isEmpty()) {
            this.nonAnnotatedClasses.add(beanType);
            return bean;
        }
        log.debug("process [{}] annotated methods for bean [{}]", (Object)annotatedMethods.size(), (Object)beanName);
        this.processAnnotatedMethods(bean, beanType, (Multimap<Method, T>)annotatedMethods);
        return bean;
    }

    protected abstract void processAnnotatedMethods(Object var1, Class<?> var2, Multimap<Method, T> var3);

    @Nullable
    protected abstract Method findMethodForAnnotation(Class<?> var1, T var2);

    private void resolveMethodLevelAnnotations(Class<?> beanType, Multimap<Method, T> collectedMethods) {
        Map methodLevelAnnotations = MethodIntrospector.selectMethods(beanType, method -> {
            Set annotations = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)method, this.annotationType);
            return annotations.isEmpty() ? null : annotations;
        });
        if (CollUtil.isNotEmpty((Map)methodLevelAnnotations)) {
            methodLevelAnnotations.forEach((arg_0, arg_1) -> collectedMethods.putAll(arg_0, arg_1));
        }
    }

    private void resolveClassLevelAnnotations(Class<?> beanType, Multimap<Method, T> collectedMethods) {
        Set classLevelAnnotations = AnnotatedElementUtils.findMergedRepeatableAnnotations(beanType, this.annotationType);
        classLevelAnnotations.forEach(annotation -> {
            Method method = this.findMethodForAnnotation(beanType, annotation);
            if (Objects.nonNull(method)) {
                collectedMethods.put((Object)method, annotation);
            }
        });
    }

    public AbstractAnnotatedMethodPostProcessor(Class<T> annotationType) {
        this.annotationType = annotationType;
    }
}

