/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.parser;

import cn.crane4j.annotation.Assemble;
import cn.crane4j.annotation.Disassemble;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.parser.AnnotationAwareBeanOperationParser;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Sorted;
import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.springboot.support.expression.SpelExpressionContext;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.expression.BeanResolver;
import org.springframework.util.StringValueResolver;

public class SpringAnnotationAwareBeanOperationParser
extends AnnotationAwareBeanOperationParser
implements EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationAwareBeanOperationParser.class);
    private final ExpressionEvaluator evaluator;
    private final BeanFactoryResolver beanFactoryResolver;
    private StringValueResolver stringValueResolver;

    public SpringAnnotationAwareBeanOperationParser(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, ExpressionEvaluator evaluator, ApplicationContext applicationContext) {
        super(annotationFinder, globalConfiguration, Sorted.comparator());
        this.evaluator = evaluator;
        this.beanFactoryResolver = new BeanFactoryResolver((BeanFactory)applicationContext);
    }

    protected Container<?> getContainer(Assemble annotation) {
        ContainerProvider provider = ConfigurationUtil.getContainerProvider((Crane4jGlobalConfiguration)this.globalConfiguration, (String)annotation.containerProviderName(), (Class)annotation.containerProvider());
        provider = (ContainerProvider)ObjectUtil.defaultIfNull((Object)provider, (Object)this.globalConfiguration);
        Container container = null;
        String namespace = this.stringValueResolver.resolveStringValue(annotation.container());
        try {
            container = this.getContainerByExpression(namespace, provider);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Objects.isNull(container)) {
            container = provider.getContainer(namespace);
        }
        Assert.notNull((Object)container, (Supplier)SpringAnnotationAwareBeanOperationParser.throwException((String)"cannot find container [{}] from provider [{}]", (Object[])new Object[]{annotation.container(), provider.getClass()}));
        return container;
    }

    protected List<Assemble> parseAssembleAnnotations(Class<?> beanType) {
        return this.parseAnnotationForDeclaredFields(beanType, Assemble.class, SpringAnnotationAwareBeanOperationParser::processAnnotation);
    }

    protected List<Disassemble> parseDisassembleAnnotations(Class<?> beanType) {
        return this.parseAnnotationForDeclaredFields(beanType, Disassemble.class, SpringAnnotationAwareBeanOperationParser::processAnnotation);
    }

    private Container<?> getContainerByExpression(String expression, ContainerProvider provider) {
        Object target = null;
        try {
            SpelExpressionContext context = new SpelExpressionContext();
            context.setBeanResolver((BeanResolver)this.beanFactoryResolver);
            context.setVariable("provider", provider);
            target = this.evaluator.execute(expression, Object.class, (ExpressionContext)context);
        }
        catch (Exception e) {
            log.debug("cannot resolve container or namespace of container from expression [{}]", (Object)expression);
        }
        if (target instanceof Container) {
            return (Container)target;
        }
        if (target instanceof String) {
            return provider.getContainer((String)target);
        }
        return null;
    }

    private static <T extends Annotation> T processAnnotation(T a, Field f) {
        ReflectUtils.setAttributeValue(a, (String)"key", (Object)f.getName());
        Order annotation = (Order)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)f, Order.class);
        if (Objects.nonNull(annotation)) {
            ReflectUtils.setAttributeValue(a, (String)"sort", (Object)annotation.value());
        }
        return a;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.stringValueResolver = resolver;
    }
}

