/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.config;

import cn.crane4j.annotation.ContainerConstant;
import cn.crane4j.annotation.ContainerEnum;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.container.ConstantContainer;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.springboot.config.Crane4jProperties;
import cn.crane4j.springboot.support.Crane4jApplicationContext;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ClassUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class Crane4jInitializer
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(Crane4jInitializer.class);
    private final MetadataReaderFactory readerFactory;
    private final ResourcePatternResolver resolver;
    private final CacheManager cacheManager;
    private final Crane4jProperties crane4jProperties;
    private final AnnotationFinder annotationFinder;
    private final Crane4jApplicationContext configuration;
    private final Collection<BeanOperationParser> parsers;

    public void run(ApplicationArguments args) {
        log.info("start initializing component cache......");
        this.loadContainerEnum();
        this.loadConstantClass();
        this.loadOperateEntity();
    }

    private void loadConstantClass() {
        Set<String> constantPackages = this.crane4jProperties.getContainerConstantPackages();
        constantPackages.forEach(path -> this.readMetadata((String)path, reader -> {
            Class targetType = ClassUtil.loadClass((String)reader.getClassMetadata().getClassName());
            if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)targetType, ContainerConstant.class)) {
                ConstantContainer container = ConstantContainer.forConstantClass((Class)targetType, (AnnotationFinder)this.annotationFinder);
                this.configuration.registerContainer((Container<?>)container);
            }
        }));
    }

    private void loadContainerEnum() {
        Set<String> enumPackages = this.crane4jProperties.getContainerEnumPackages();
        enumPackages.forEach(path -> this.readMetadata((String)path, reader -> {
            boolean supported;
            Class targetType = ClassUtil.loadClass((String)reader.getClassMetadata().getClassName());
            boolean bl = supported = targetType.isEnum() && (!this.crane4jProperties.isOnlyLoadAnnotatedEnum() || AnnotatedElementUtils.isAnnotated((AnnotatedElement)targetType, ContainerEnum.class));
            if (supported) {
                ConstantContainer container = ConstantContainer.forEnum((Class)targetType, (AnnotationFinder)this.annotationFinder);
                this.configuration.registerContainer((Container<?>)container);
            }
        }));
    }

    private void loadOperateEntity() {
        Set<String> entityPackages = this.crane4jProperties.getOperateEntityPackages();
        entityPackages.forEach(path -> this.readMetadata((String)path, reader -> {
            Class targetType = ClassUtil.loadClass((String)reader.getClassMetadata().getClassName());
            this.parsers.forEach(parser -> parser.parse(targetType));
        }));
    }

    private void readMetadata(String path, Consumer<MetadataReader> consumer) {
        Resource[] resources;
        String actualPath = CharSequenceUtil.replace((CharSequence)path, (CharSequence)".", (CharSequence)"/");
        for (Resource resource : resources = this.resolver.getResources(actualPath)) {
            MetadataReader reader = this.readerFactory.getMetadataReader(resource);
            consumer.accept(reader);
        }
    }

    public Crane4jInitializer(MetadataReaderFactory readerFactory, ResourcePatternResolver resolver, CacheManager cacheManager, Crane4jProperties crane4jProperties, AnnotationFinder annotationFinder, Crane4jApplicationContext configuration, Collection<BeanOperationParser> parsers) {
        this.readerFactory = readerFactory;
        this.resolver = resolver;
        this.cacheManager = cacheManager;
        this.crane4jProperties = crane4jProperties;
        this.annotationFinder = annotationFinder;
        this.configuration = configuration;
        this.parsers = parsers;
    }
}

