/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.annotation.AssembleMethod;
import cn.crane4j.core.parser.handler.AssembleMethodAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.container.MethodContainerFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;

public class BeanAwareAssembleMethodAnnotationHandler
extends AssembleMethodAnnotationHandler {
    private final ApplicationContext applicationContext;

    public BeanAwareAssembleMethodAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, Collection<MethodContainerFactory> methodContainerFactories, ApplicationContext applicationContext, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        super(annotationFinder, globalConfiguration, methodContainerFactories, propertyMappingStrategyManager);
        this.applicationContext = applicationContext;
    }

    protected @NonNull Class<?> resolveTargetType(AssembleMethod annotation) {
        Object target = this.findTargetFromSpring(annotation.targetType(), annotation.target());
        return Objects.isNull(target) ? super.resolveTargetType(annotation) : AopUtils.getTargetClass((Object)target);
    }

    protected @Nullable Object getTargetInstance(Class<?> targetType, AssembleMethod annotation) {
        Object target = this.findTargetFromSpring(targetType, annotation.target());
        if (target != null) {
            return target;
        }
        return super.getTargetInstance(targetType, annotation);
    }

    private @Nullable Object findTargetFromSpring(Class<?> beanType, String beanName) {
        Object target = BeanAwareAssembleMethodAnnotationHandler.tryGet(() -> this.applicationContext.getBean(beanName));
        if (Objects.nonNull(target)) {
            return target;
        }
        target = BeanAwareAssembleMethodAnnotationHandler.tryGet(() -> this.applicationContext.getBean(beanName, beanType));
        if (Objects.nonNull(target)) {
            return target;
        }
        target = BeanAwareAssembleMethodAnnotationHandler.tryGet(() -> this.applicationContext.getBean(beanType));
        if (Objects.nonNull(target)) {
            return target;
        }
        return null;
    }

    private static <T> T tryGet(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

