/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.aop;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.aop.MethodResultAutoOperateSupport;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.expression.MethodBaseExpressionExecuteDelegate;
import cn.crane4j.extension.spring.aop.AutoOperatePointcut;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class MethodResultAutoOperateAdvisor
extends MethodResultAutoOperateSupport
implements PointcutAdvisor,
MethodInterceptor,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MethodResultAutoOperateAdvisor.class);
    private final Pointcut pointcut = AutoOperatePointcut.forAnnotatedMethod((m, c) -> !Objects.equals(m.getReturnType(), Void.TYPE) && AnnotatedElementUtils.isAnnotated((AnnotatedElement)m, AutoOperate.class));

    public MethodResultAutoOperateAdvisor(AutoOperateAnnotatedElementResolver elementResolver, MethodBaseExpressionExecuteDelegate expressionExecuteDelegate) {
        super(elementResolver, expressionExecuteDelegate);
        log.info("enable automatic filling of method result");
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        AutoOperate annotation = (AutoOperate)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, AutoOperate.class);
        Object result = methodInvocation.proceed();
        try {
            this.afterMethodInvoke(annotation, method, result, methodInvocation.getArguments());
        }
        catch (Exception ex) {
            log.error("cannot auto operate result for method [{}]", (Object)method);
            ex.printStackTrace();
            throw ex;
        }
        return result;
    }

    public @NonNull Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return false;
    }

    public void destroy() {
        this.methodCaches.clear();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }
}

