/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.scanner;

import cn.crane4j.annotation.Operator;
import cn.crane4j.core.support.operator.OperatorProxyFactory;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.extension.spring.annotation.OperatorScan;
import cn.crane4j.extension.spring.scanner.ClassScanner;
import cn.crane4j.extension.spring.util.ContainerResolveUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

public class OperatorBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(OperatorBeanDefinitionRegistrar.class);

    public void registerBeanDefinitions(@NonNull AnnotationMetadata importingClassMetadata, @NonNull BeanDefinitionRegistry registry) {
        Class<OperatorScan> annotationType = OperatorScan.class;
        Set<Class<?>> types = ContainerResolveUtils.resolveComponentTypesFromMetadata(AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(annotationType.getName())), ClassScanner.INSTANCE, str -> str);
        if (CollectionUtils.isEmpty(types)) {
            log.warn("cannot find any class by scan configuration for annotation: [{}]", (Object)annotationType.getName());
            return;
        }
        this.doRegisterBeanDefinitions(types, registry);
    }

    protected void doRegisterBeanDefinitions(Set<Class<?>> classes, BeanDefinitionRegistry registry) {
        classes.stream().filter(Class::isInterface).filter(operatorType -> AnnotatedElementUtils.isAnnotated((AnnotatedElement)operatorType, Operator.class)).forEach(operator -> OperatorBeanDefinitionRegistrar.registerOperatorBeanDefinition(registry, operator));
    }

    private static void registerOperatorBeanDefinition(BeanDefinitionRegistry registry, Class<?> operatorType) {
        log.debug("register operator bean definition for [{}]", operatorType);
        AbstractBeanDefinition factoryBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(OperatorProxyFactoryBean.class).addAutowiredProperty("operatorProxyFactory").addPropertyValue("operatorType", operatorType).setAutowireMode(2).getBeanDefinition();
        String factoryBeanName = AnnotationBeanNameGenerator.INSTANCE.generateBeanName((BeanDefinition)factoryBeanDefinition, registry);
        factoryBeanName = factoryBeanName + "#" + operatorType.getName();
        registry.registerBeanDefinition(factoryBeanName, (BeanDefinition)factoryBeanDefinition);
        AbstractBeanDefinition operatorBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(operatorType).setFactoryMethodOnBean("getObject", factoryBeanName).setLazyInit(true).getBeanDefinition();
        String operatorBeanName = AnnotationBeanNameGenerator.INSTANCE.generateBeanName((BeanDefinition)operatorBeanDefinition, registry);
        registry.registerBeanDefinition(operatorBeanName, (BeanDefinition)operatorBeanDefinition);
    }

    public static class OperatorProxyFactoryBean<T>
    implements FactoryBean<T> {
        private OperatorProxyFactory operatorProxyFactory;
        private Class<T> operatorType;

        public T getObject() {
            return (T)this.operatorProxyFactory.get(this.operatorType);
        }

        public Class<?> getObjectType() {
            return this.operatorType;
        }

        public void setOperatorProxyFactory(OperatorProxyFactory operatorProxyFactory) {
            this.operatorProxyFactory = operatorProxyFactory;
        }

        public void setOperatorType(Class<T> operatorType) {
            this.operatorType = operatorType;
        }
    }
}

