/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.aop;

import cn.crane4j.annotation.ArgAutoOperate;
import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.aop.MethodArgumentAutoOperateSupport;
import cn.crane4j.core.support.expression.MethodBaseExpressionExecuteDelegate;
import cn.crane4j.extension.spring.aop.AutoOperatePointcut;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class MethodArgumentAutoOperateAdvisor
extends MethodArgumentAutoOperateSupport
implements PointcutAdvisor,
MethodInterceptor,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MethodArgumentAutoOperateAdvisor.class);
    private final Pointcut pointcut = AutoOperatePointcut.forAnnotatedMethod((m, c) -> m.getParameterCount() > 0 && (AnnotatedElementUtils.isAnnotated((AnnotatedElement)m, ArgAutoOperate.class) || Arrays.stream(m.getParameters()).anyMatch(p -> p.isAnnotationPresent(AutoOperate.class))));

    public MethodArgumentAutoOperateAdvisor(AutoOperateAnnotatedElementResolver elementResolver, MethodBaseExpressionExecuteDelegate expressionExecuteDelegate, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder) {
        super(elementResolver, expressionExecuteDelegate, parameterNameFinder, annotationFinder);
        log.info("enable automatic filling of method argument");
    }

    public void destroy() {
        for (Object[] elements : this.methodParameterCaches.values()) {
            Arrays.fill(elements, null);
        }
        this.methodParameterCaches.clear();
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        try {
            super.beforeMethodInvoke(method, methodInvocation.getArguments());
        }
        catch (Exception ex) {
            log.error("cannot auto operate input arguments for method [{}]", (Object)method);
            ex.printStackTrace();
            throw ex;
        }
        return methodInvocation.proceed();
    }

    public @NonNull Advice getAdvice() {
        return this;
    }

    public boolean isPerInstance() {
        return false;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }
}

