/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.annotation.Assemble;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.parser.handler.AssembleAnnotationHandler;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.StringUtils;
import cn.crane4j.extension.spring.expression.SpelExpressionContext;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.expression.BeanResolver;
import org.springframework.util.StringValueResolver;

public class SpringAssembleAnnotationHandler
extends AssembleAnnotationHandler
implements EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(SpringAssembleAnnotationHandler.class);
    private final ExpressionEvaluator evaluator;
    private final BeanResolver beanResolver;
    private StringValueResolver stringValueResolver;

    public SpringAssembleAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, ExpressionEvaluator evaluator, BeanResolver beanResolver) {
        super(annotationFinder, globalConfiguration, Crane4jGlobalSorter.comparator());
        this.evaluator = evaluator;
        this.beanResolver = beanResolver;
    }

    protected String getContainerNamespace(Assemble annotation) {
        String namespace = this.resolveNamespace(annotation.container());
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            return "";
        }
        String providerName = this.resolveNamespace(annotation.containerProvider());
        return ContainerManager.canonicalNamespace((String)namespace, (String)providerName);
    }

    private @Nullable String resolveNamespace(String expression) {
        String namespace = Objects.isNull(this.stringValueResolver) ? expression : this.stringValueResolver.resolveStringValue(expression);
        try {
            SpelExpressionContext context = new SpelExpressionContext();
            context.setBeanResolver(this.beanResolver);
            namespace = (String)this.evaluator.execute(expression, String.class, (ExpressionContext)context);
        }
        catch (Exception e) {
            log.debug("cannot resolve container or namespace of container from expression [{}]", (Object)expression);
        }
        return namespace;
    }

    public void setEmbeddedValueResolver(@NonNull StringValueResolver resolver) {
        this.stringValueResolver = resolver;
    }
}

