/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.operator;

import cn.crane4j.annotation.Operator;
import cn.crane4j.core.support.operator.OperatorProxyFactory;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import cn.crane4j.extension.spring.operator.OperatorScan;
import cn.crane4j.extension.spring.scanner.ClassScanner;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

public class OperatorBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger log = LoggerFactory.getLogger(OperatorBeanDefinitionRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(OperatorScan.class.getName()));
        if (annotationAttributes != null) {
            this.doRegisterBeanDefinitions(annotationAttributes, registry);
        }
    }

    private void doRegisterBeanDefinitions(AnnotationAttributes annotationAttributes, BeanDefinitionRegistry registry) {
        ClassScanner classScanner = new ClassScanner();
        Set operatorTypes = Stream.of(annotationAttributes.getStringArray("scan")).filter(StringUtils::isNotEmpty).map(xva$0 -> classScanner.scan((String)xva$0)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).filter(Class::isInterface).filter(operatorType -> AnnotatedElementUtils.isAnnotated((AnnotatedElement)operatorType, Operator.class)).collect(Collectors.toSet());
        CollectionUtils.addAll(operatorTypes, (Object[])annotationAttributes.getClassArray("includes"));
        Arrays.asList(annotationAttributes.getClassArray("excludes")).forEach(operatorTypes::remove);
        for (Class operatorType2 : operatorTypes) {
            OperatorBeanDefinitionRegistrar.registerOperatorBeanDefinition(registry, operatorType2);
        }
    }

    private static void registerOperatorBeanDefinition(BeanDefinitionRegistry registry, Class<?> operatorType) {
        log.debug("register operator bean definition for [{}]", operatorType);
        AbstractBeanDefinition factoryBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(OperatorProxyFactoryBean.class).addAutowiredProperty("operatorProxyFactory").addPropertyValue("operatorType", operatorType).setAutowireMode(2).getBeanDefinition();
        String factoryBeanName = AnnotationBeanNameGenerator.INSTANCE.generateBeanName((BeanDefinition)factoryBeanDefinition, registry);
        factoryBeanName = factoryBeanName + "#" + operatorType.getName();
        registry.registerBeanDefinition(factoryBeanName, (BeanDefinition)factoryBeanDefinition);
        AbstractBeanDefinition operatorBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(operatorType).setFactoryMethodOnBean("getObject", factoryBeanName).setLazyInit(true).getBeanDefinition();
        String operatorBeanName = AnnotationBeanNameGenerator.INSTANCE.generateBeanName((BeanDefinition)operatorBeanDefinition, registry);
        registry.registerBeanDefinition(operatorBeanName, (BeanDefinition)operatorBeanDefinition);
    }

    public static class OperatorProxyFactoryBean<T>
    implements FactoryBean<T> {
        private OperatorProxyFactory operatorProxyFactory;
        private Class<T> operatorType;

        public T getObject() {
            return (T)this.operatorProxyFactory.get(this.operatorType);
        }

        public Class<?> getObjectType() {
            return this.operatorType;
        }

        public void setOperatorProxyFactory(OperatorProxyFactory operatorProxyFactory) {
            this.operatorProxyFactory = operatorProxyFactory;
        }

        public void setOperatorType(Class<T> operatorType) {
            this.operatorType = operatorType;
        }
    }
}

