/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.aop;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.aop.MethodResultAutoOperateSupport;
import cn.crane4j.core.support.expression.MethodBaseExpressionExecuteDelegate;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.annotation.AnnotatedElementUtils;

@Aspect
public class MethodResultAutoOperateAspect
extends MethodResultAutoOperateSupport
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MethodResultAutoOperateAspect.class);

    public MethodResultAutoOperateAspect(AutoOperateAnnotatedElementResolver elementResolver, MethodBaseExpressionExecuteDelegate expressionExecuteDelegate) {
        super(elementResolver, expressionExecuteDelegate);
        log.info("enable automatic filling of method result");
    }

    @AfterReturning(returning="result", pointcut="@annotation(cn.crane4j.annotation.AutoOperate)")
    public void afterMethodInvoke(JoinPoint joinPoint, Object result) {
        if (Objects.isNull(result)) {
            return;
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        AutoOperate annotation = (AutoOperate)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, AutoOperate.class);
        super.afterMethodInvoke(annotation, method, result, joinPoint.getArgs());
    }

    public void destroy() {
        this.methodCaches.clear();
    }
}

