/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring.aop;

import cn.crane4j.annotation.ArgAutoOperate;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.aop.MethodArgumentAutoOperateSupport;
import cn.crane4j.core.support.expression.MethodBaseExpressionExecuteDelegate;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.annotation.AnnotatedElementUtils;

@Aspect
public class MethodArgumentAutoOperateAspect
extends MethodArgumentAutoOperateSupport
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MethodArgumentAutoOperateAspect.class);

    public MethodArgumentAutoOperateAspect(AutoOperateAnnotatedElementResolver elementResolver, MethodBaseExpressionExecuteDelegate expressionExecuteDelegate, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder) {
        super(elementResolver, expressionExecuteDelegate, parameterNameFinder, annotationFinder);
        log.info("enable automatic filling of method argument");
    }

    @Before(value="@annotation(cn.crane4j.annotation.ArgAutoOperate)")
    public void beforeMethodInvoke(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ArgAutoOperate annotation = (ArgAutoOperate)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ArgAutoOperate.class);
        super.beforeMethodInvoke(annotation, method, joinPoint.getArgs());
    }

    public void destroy() {
        for (Object[] elements : this.methodParameterCaches.values()) {
            Arrays.fill(elements, null);
        }
        this.methodParameterCaches.clear();
    }
}

