/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.annotation.Assemble;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.parser.AssembleAnnotationResolver;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Sorted;
import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.core.util.ObjectUtils;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.extension.spring.expression.SpelExpressionContext;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.expression.BeanResolver;
import org.springframework.util.StringValueResolver;

public class SpringAssembleAnnotationResolver
extends AssembleAnnotationResolver
implements EmbeddedValueResolverAware {
    private static final Logger log = LoggerFactory.getLogger(SpringAssembleAnnotationResolver.class);
    private final ExpressionEvaluator evaluator;
    private final BeanResolver beanResolver;
    private StringValueResolver stringValueResolver;

    public SpringAssembleAnnotationResolver(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, ExpressionEvaluator evaluator, BeanResolver beanResolver) {
        super(annotationFinder, globalConfiguration, Sorted.comparator());
        this.evaluator = evaluator;
        this.beanResolver = beanResolver;
    }

    protected Multimap<AnnotatedElement, Assemble> parseAnnotationForFields(Class<?> beanType) {
        Multimap result = super.parseAnnotationForFields(beanType);
        result.forEach((e, a) -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)e, Order.class)).ifPresent(o -> ReflectUtils.setAttributeValue((Annotation)a, (String)"sort", (Object)o.value())));
        return result;
    }

    protected Container<?> getContainer(Assemble annotation) {
        ContainerProvider provider = ConfigurationUtil.getContainerProvider((Crane4jGlobalConfiguration)this.globalConfiguration, (String)annotation.containerProviderName(), (Class)annotation.containerProvider());
        provider = (ContainerProvider)ObjectUtils.defaultIfNull((Object)provider, (Object)this.globalConfiguration);
        Container container = null;
        String namespace = this.stringValueResolver.resolveStringValue(annotation.container());
        try {
            container = this.getContainerByExpression(namespace, provider);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Objects.isNull(container)) {
            container = provider.getContainer(namespace);
        }
        Asserts.isNotNull((Object)container, (String)"cannot find container [{}] from provider [{}]", (Object[])new Object[]{annotation.container(), annotation.containerProvider()});
        return container;
    }

    private Container<?> getContainerByExpression(String expression, ContainerProvider provider) {
        Object target = null;
        try {
            SpelExpressionContext context = new SpelExpressionContext();
            context.setBeanResolver(this.beanResolver);
            context.setVariable("provider", provider);
            target = this.evaluator.execute(expression, Object.class, (ExpressionContext)context);
        }
        catch (Exception e) {
            log.debug("cannot resolve container or namespace of container from expression [{}]", (Object)expression);
        }
        if (target instanceof Container) {
            return (Container)target;
        }
        if (target instanceof String) {
            return provider.getContainer((String)target);
        }
        return null;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.stringValueResolver = resolver;
    }
}

