/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.core.container.ConfigurableContainerProvider;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.SimpleConfigurableContainerProvider;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.callback.ContainerRegisterAware;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropertyOperator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;

public class Crane4jApplicationContext
extends SimpleConfigurableContainerProvider
implements Crane4jGlobalConfiguration,
SmartInitializingSingleton,
DisposableBean,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Crane4jApplicationContext.class);
    private final ApplicationContext applicationContext;

    public boolean containsContainer(String namespace) {
        return super.containsContainer(namespace) || this.applicationContext.containsBean(namespace);
    }

    public Container<?> getContainer(String namespace) {
        return super.containsContainer(namespace) ? super.getContainer(namespace) : (Container)this.applicationContext.getBean(namespace, Container.class);
    }

    public ConverterManager getConverterManager() {
        return (ConverterManager)this.applicationContext.getBean(ConverterManager.class);
    }

    public PropertyOperator getPropertyOperator() {
        return (PropertyOperator)this.applicationContext.getBean(PropertyOperator.class);
    }

    public TypeResolver getTypeResolver() {
        return (TypeResolver)this.applicationContext.getBean(TypeResolver.class);
    }

    public <T extends ContainerProvider> T getContainerProvider(Class<T> providerType) {
        return (T)((ContainerProvider)this.applicationContext.getBean(providerType));
    }

    public ContainerProvider getContainerProvider(String providerName) {
        return (ContainerProvider)this.applicationContext.getBean(providerName, ContainerProvider.class);
    }

    public BeanOperationExecutor getBeanOperationExecutor(Class<? extends BeanOperationExecutor> executorType) {
        return (BeanOperationExecutor)this.applicationContext.getBean(executorType);
    }

    public BeanOperationExecutor getBeanOperationExecutor(String executorName) {
        return (BeanOperationExecutor)this.applicationContext.getBean(executorName, BeanOperationExecutor.class);
    }

    public BeanOperationParser getBeanOperationsParser(Class<? extends BeanOperationParser> parserType) {
        return (BeanOperationParser)this.applicationContext.getBean(parserType);
    }

    public BeanOperationParser getBeanOperationsParser(String parserName) {
        return (BeanOperationParser)this.applicationContext.getBean(parserName, BeanOperationParser.class);
    }

    public AssembleOperationHandler getAssembleOperationHandler(Class<? extends AssembleOperationHandler> handlerType) {
        return (AssembleOperationHandler)this.applicationContext.getBean(handlerType);
    }

    public AssembleOperationHandler getAssembleOperationHandler(String handlerName) {
        return (AssembleOperationHandler)this.applicationContext.getBean(handlerName, AssembleOperationHandler.class);
    }

    public DisassembleOperationHandler getDisassembleOperationHandler(Class<? extends DisassembleOperationHandler> handlerType) {
        return (DisassembleOperationHandler)this.applicationContext.getBean(handlerType);
    }

    public DisassembleOperationHandler getDisassembleOperationHandler(String handlerName) {
        return (DisassembleOperationHandler)this.applicationContext.getBean(handlerName, DisassembleOperationHandler.class);
    }

    public void afterPropertiesSet() {
        Map containerProviderMap = this.applicationContext.getBeansOfType(ConfigurableContainerProvider.class);
        this.applicationContext.getBeansOfType(ContainerRegisterAware.class).forEach((name, aware) -> {
            log.info("install container register aware [{}]", name);
            this.addContainerRegisterAware((ContainerRegisterAware)aware);
            containerProviderMap.values().forEach(provider -> provider.addContainerRegisterAware(aware));
        });
    }

    public void afterSingletonsInstantiated() {
        this.applicationContext.getBeansOfType(Container.class).values().forEach(arg_0 -> ((Crane4jApplicationContext)this).registerContainer(arg_0));
    }

    public void destroy() {
        log.info("global configuration has been destroyed.");
        this.containerMap.clear();
    }

    public Crane4jApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

