/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.annotation.ContainerMethod;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.container.AbstractMethodContainerAnnotationProcessor;
import cn.crane4j.core.support.container.MethodContainerFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;

@Order
public class MergedAnnotationMethodContainerPostProcessor
extends AbstractMethodContainerAnnotationProcessor
implements BeanPostProcessor,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MergedAnnotationMethodContainerPostProcessor.class);
    private final Crane4jGlobalConfiguration configuration;

    public MergedAnnotationMethodContainerPostProcessor(Collection<MethodContainerFactory> factories, Crane4jGlobalConfiguration configuration) {
        super(factories);
        this.configuration = configuration;
    }

    public void destroy() {
        this.nonAnnotatedClasses.clear();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class beanType = AopUtils.getTargetClass((Object)bean);
        Collection containers = this.process(bean, beanType);
        log.debug("process [{}] annotated methods for bean [{}]", (Object)containers.size(), (Object)beanName);
        containers.forEach(arg_0 -> ((Crane4jGlobalConfiguration)this.configuration).registerContainer(arg_0));
        return bean;
    }

    protected Collection<ContainerMethod> resolveAnnotationsForClass(Class<?> type) {
        return AnnotatedElementUtils.findMergedRepeatableAnnotations(type, ContainerMethod.class);
    }

    protected Collection<ContainerMethod> resolveAnnotationsForMethod(Method method) {
        return AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)method, ContainerMethod.class);
    }
}

