/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.redis;

import cn.crane4j.extension.redis.AbstractRedisCacheManager;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.data.redis.core.RedisTemplate;

public class GeneralRedisCacheManager<K, V>
extends AbstractRedisCacheManager<K, V> {
    private final BiFunction<String, K, K> keyResolver;
    private final Function<Object, V> valueResolver;

    public GeneralRedisCacheManager(@NonNull RedisTemplate<K, V> redisTemplate, @NonNull BiFunction<String, K, K> keyResolver, @NonNull Function<Object, V> valueResolver) {
        super(redisTemplate);
        this.keyResolver = keyResolver;
        this.valueResolver = valueResolver;
    }

    @Override
    protected K resolveCacheKey(String cacheName, K key) {
        return this.keyResolver.apply(cacheName, key);
    }

    @Override
    protected V resolveCacheValue(Object value) {
        return this.valueResolver.apply(value);
    }
}

