/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.redis;

import cn.crane4j.core.cache.AbstractCacheManager;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;

public abstract class AbstractRedisCacheManager<K, V>
extends AbstractCacheManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisCacheManager.class);
    protected final @NonNull RedisTemplate<K, V> redisTemplate;

    protected @NonNull RedisCacheObject doCreateCache(String name, Long expireTime, TimeUnit timeUnit) {
        return new RedisCacheObject(name, expireTime, timeUnit);
    }

    protected abstract K resolveCacheKey(String var1, K var2);

    protected abstract V resolveCacheValue(Object var1);

    protected void clearCache(String cacheName) {
        log.warn("Clear all cache value is not supported in redis cache [{}]", (Object)cacheName);
    }

    protected void executePipelined(final Consumer<RedisOperations<K, V>> consumer) {
        SessionCallback<Object> callback = new SessionCallback<Object>(){

            public <U, R> Object execute(@NonNull RedisOperations<U, R> operations) throws DataAccessException {
                RedisOperations<U, R> ops = operations;
                consumer.accept(ops);
                return null;
            }
        };
        this.redisTemplate.executePipelined((SessionCallback)callback);
    }

    public AbstractRedisCacheManager(@NonNull RedisTemplate<K, V> redisTemplate) {
        if (redisTemplate == null) {
            throw new NullPointerException("redisTemplate is marked non-null but is null");
        }
        this.redisTemplate = redisTemplate;
    }

    protected class RedisCacheObject
    extends AbstractCacheManager.AbstractCacheObject<K> {
        private final long expireTime;
        private final TimeUnit timeUnit;

        protected RedisCacheObject(String name, long expireTime, TimeUnit timeUnit) {
            super(name);
            this.expireTime = expireTime;
            this.timeUnit = timeUnit;
        }

        public void clear() {
            AbstractRedisCacheManager.this.clearCache(this.getName());
        }

        public void putAll(Map<K, Object> caches) {
            AbstractRedisCacheManager.this.executePipelined(ops -> {
                for (Map.Entry entry : caches.entrySet()) {
                    Object cacheKey = AbstractRedisCacheManager.this.resolveCacheKey(this.getName(), entry.getKey());
                    Object cacheValue = AbstractRedisCacheManager.this.resolveCacheValue(entry.getValue());
                    ops.opsForValue().set(cacheKey, cacheValue, this.expireTime, this.timeUnit);
                }
            });
        }

        public Map<K, Object> getAll(Iterable<K> keys) {
            Set keySet = StreamSupport.stream(keys.spliterator(), false).map(key -> AbstractRedisCacheManager.this.resolveCacheKey(this.getName(), key)).collect(Collectors.toCollection(LinkedHashSet::new));
            List values = AbstractRedisCacheManager.this.redisTemplate.opsForValue().multiGet((Collection)keySet);
            if (Objects.isNull(values) || values.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap results = new LinkedHashMap(16);
            int index = 0;
            for (Object key2 : keys) {
                Object value;
                if (!Objects.nonNull(value = values.get(index++))) continue;
                results.put(key2, value);
            }
            return results;
        }

        public void removeAll(Iterable<K> keys) {
            Set keySet = StreamSupport.stream(keys.spliterator(), false).map(key -> AbstractRedisCacheManager.this.resolveCacheKey(this.getName(), key)).collect(Collectors.toSet());
            AbstractRedisCacheManager.this.redisTemplate.delete(keySet);
        }

        public @Nullable Object get(K key) {
            Object cacheKey = AbstractRedisCacheManager.this.resolveCacheKey(this.getName(), key);
            return AbstractRedisCacheManager.this.redisTemplate.opsForValue().get(cacheKey);
        }

        public void put(K key, Object value) {
            Object cacheKey = AbstractRedisCacheManager.this.resolveCacheKey(this.getName(), key);
            Object cacheValue = AbstractRedisCacheManager.this.resolveCacheValue(value);
            AbstractRedisCacheManager.this.redisTemplate.opsForValue().set(cacheKey, cacheValue, this.expireTime, this.timeUnit);
        }

        public void putIfAbsent(K key, Object value) {
            Object cacheKey = AbstractRedisCacheManager.this.resolveCacheKey(this.getName(), key);
            Object cacheValue = AbstractRedisCacheManager.this.resolveCacheValue(value);
            AbstractRedisCacheManager.this.redisTemplate.opsForValue().setIfAbsent(cacheKey, cacheValue, this.expireTime, this.timeUnit);
        }

        public void remove(K key) {
            Object cacheKey = AbstractRedisCacheManager.this.resolveCacheKey(this.getName(), key);
            AbstractRedisCacheManager.this.redisTemplate.delete(cacheKey);
        }
    }
}

