/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.redis;

import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.extension.redis.AbstractRedisCacheManager;
import java.util.Collection;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class StringKeyRedisCacheManager
extends AbstractRedisCacheManager<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(StringKeyRedisCacheManager.class);
    private @NonNull String globalPrefix = "crane4j:cache:";
    private boolean enableClearCache = false;

    public StringKeyRedisCacheManager(@NonNull RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
    }

    @Override
    protected void clearCache(String cacheName) {
        if (this.enableClearCache) {
            String command = this.globalPrefix + ":" + cacheName + ":*";
            Set keys = this.redisTemplate.keys((Object)command);
            if (CollectionUtils.isNotEmpty((Collection)keys)) {
                log.warn("Clear [{}] keys from cache [{}] by command [{}]", new Object[]{keys.size(), cacheName, command});
                this.redisTemplate.delete((Collection)keys);
            }
            return;
        }
        super.clearCache(cacheName);
    }

    @Override
    protected String resolveCacheKey(String cacheName, String key) {
        return this.globalPrefix + ":" + cacheName + ":" + key;
    }

    @Override
    protected Object resolveCacheValue(Object value) {
        return value;
    }

    public void setGlobalPrefix(@NonNull String globalPrefix) {
        if (globalPrefix == null) {
            throw new NullPointerException("globalPrefix is marked non-null but is null");
        }
        this.globalPrefix = globalPrefix;
    }

    public void setEnableClearCache(boolean enableClearCache) {
        this.enableClearCache = enableClearCache;
    }
}

