/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.jackson;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.exception.OperationExecuteException;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.auto.AutoOperateAnnotatedElementResolver;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class JsonNodeAutoOperateSerializerModifier
extends BeanSerializerModifier {
    private final AutoOperateSerializeContext context = new AutoOperateSerializeContext();
    private final AutoOperateAnnotatedElementResolver annotatedElementResolver;
    private final ObjectMapper objectMapper;
    private final AnnotationFinder annotationFinder;

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        Class targetType = beanDesc.getType().getRawClass();
        return Optional.ofNullable(this.annotationFinder.findAnnotation((AnnotatedElement)targetType, AutoOperate.class)).map(autoOperate -> this.annotatedElementResolver.resolve((AnnotatedElement)targetType, autoOperate)).filter(element -> Objects.nonNull(element.getBeanOperations()) && !element.getBeanOperations().isEmpty()).map(element -> new AutoOperateSerializer(targetType, (AutoOperateAnnotatedElement)element, (JsonSerializer<Object>)serializer)).orElse(serializer);
    }

    public JsonNodeAutoOperateSerializerModifier(AutoOperateAnnotatedElementResolver annotatedElementResolver, ObjectMapper objectMapper, AnnotationFinder annotationFinder) {
        this.annotatedElementResolver = annotatedElementResolver;
        this.objectMapper = objectMapper;
        this.annotationFinder = annotationFinder;
    }

    public class AutoOperateSerializer
    extends StdSerializer<Object> {
        private final transient AutoOperateAnnotatedElement autoOperateType;
        private final transient JsonSerializer<Object> serializer;

        protected AutoOperateSerializer(Class<Object> targetType, AutoOperateAnnotatedElement autoOperateType, JsonSerializer<Object> serializer) {
            super(targetType);
            this.autoOperateType = autoOperateType;
            this.serializer = serializer;
        }

        public void serialize(Object target, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (Objects.isNull(target)) {
                return;
            }
            if (!JsonNodeAutoOperateSerializerModifier.this.context.process(target)) {
                this.serializer.serialize(target, jsonGenerator, serializerProvider);
                return;
            }
            try {
                JsonNode jsonNode = JsonNodeAutoOperateSerializerModifier.this.objectMapper.valueToTree(target);
                this.autoOperateType.execute(Collections.singletonList(jsonNode));
                jsonGenerator.writeTree((TreeNode)jsonNode);
            }
            catch (Throwable ex) {
                throw new OperationExecuteException(ex);
            }
            finally {
                JsonNodeAutoOperateSerializerModifier.this.context.processed(target);
            }
        }
    }

    private static class AutoOperateSerializeContext {
        private final ThreadLocal<Set<Integer>> threadLocal = new ThreadLocal();

        private AutoOperateSerializeContext() {
        }

        public boolean process(Object target) {
            Set<Integer> set = this.threadLocal.get();
            if (Objects.isNull(set)) {
                set = new HashSet<Integer>();
                this.threadLocal.set(set);
            }
            return set.add(target.hashCode());
        }

        public void processed(Object target) {
            Set<Integer> set = this.threadLocal.get();
            if (Objects.nonNull(set)) {
                set.remove(target.hashCode());
                if (set.isEmpty()) {
                    this.threadLocal.remove();
                }
            }
        }
    }
}

