/*
 * Decompiled with CFR 0.152.
 */
package cn.crabapples;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;

public class LombokPlugin
extends PluginAdapter {
    private TopLevelClass topLevelClass;

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.topLevelClass = topLevelClass;
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        ArrayList<GeneratedJavaFile> list = new ArrayList<GeneratedJavaFile>();
        list.add(this.generatedJavaFile(introspectedTable));
        return list;
    }

    private GeneratedJavaFile generatedJavaFile(IntrospectedTable introspectedTable) {
        JavaModelGeneratorConfiguration configuration = this.context.getJavaModelGeneratorConfiguration();
        String targetProject = configuration.getTargetProject();
        JavaFormatter javaFormatter = this.context.getJavaFormatter();
        this.addLombokAnnotation();
        return new GeneratedJavaFile((CompilationUnit)this.topLevelClass, targetProject, javaFormatter);
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    private void addLombokAnnotation() {
        String[] annotations;
        String values = this.properties.getProperty("annotation");
        if (Objects.isNull(values)) {
            return;
        }
        for (String annotation : annotations = values.split(",")) {
            String trim = annotation.trim();
            if (trim.length() <= 0) continue;
            String packageName = MessageFormat.format("lombok.{0}", trim);
            try {
                Class<?> clazz = Class.forName(packageName);
            }
            catch (ClassNotFoundException e) {
                String exceptionMessage = MessageFormat.format("\u5f53\u524dlombok\u7248\u672c\u4e2d\u6ca1\u6709\u53d1\u73b0:[{0}]\u6ce8\u89e3\nthis lombok version not found [{0}] annotation", trim);
                throw new RuntimeException(exceptionMessage);
            }
            String annotationName = MessageFormat.format("@{0}", trim);
            this.topLevelClass.addImportedType(new FullyQualifiedJavaType(packageName));
            this.topLevelClass.addAnnotation(annotationName);
        }
    }

    public boolean validate(List<String> list) {
        return true;
    }
}

