package cn.coufran.springboot.starter.log.serializer;

import cn.coufran.springboot.starter.log.Mode;

/**
 * 基础序列化器
 * @author Coufran
 * @version 1.1.0
 * @since 1.0.0
 */
public class SimpleSerializerFactory implements SerializerFactory {
    /**
     * 获取序列化器
     * @param mode 序列化模式
     * @return 序列化器
     */
    public Serializer getSerializer(Mode mode) {
        switch (mode) {
            case TO_STRING:
                return new ToStringSerializer();
            case JSON:
                return new JsonSerializer();
            case NONE:
                return new DummySerializer();
            default:
                throw new IllegalStateException("mode " + mode + " is illegal");
        }
    }
}
