package cn.coufran.springboot.starter.log.serializer;

import cn.coufran.springboot.starter.log.Mode;

/**
 * 序列化器工厂，生成不同模式下的序列化器
 * @author Coufran
 * @version 1.0.0
 * @since 1.0.0
 */
public interface SerializerFactory {
    /**
     * 获取序列化器
     * @param mode 序列化模式
     * @return 序列化器
     */
    Serializer getSerializer(Mode mode);
}
