package cn.coufran.springboot.starter.log.serializer;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 序列化相关配置
 * @author Coufran
 * @version 1.0.0
 * @since 1.0.0
 */
@Configuration
public class SerializerConfig {
    /**
     * 序列化工厂
     * @return 序列化工厂
     */
    @Bean
    public SerializerFactory serializerFactory() {
        return new CachedSerializerFactory(new SimpleSerializerFactory());
    }
}
