package cn.coufran.springboot.starter.log.serializer;

import cn.coufran.springboot.starter.json.HibernateValueFilter;
import com.alibaba.fastjson.JSON;

/**
 * 基于JSON（Fastjson）的序列化器
 * @author Coufran
 * @version 1.0.0
 * @since 1.0.0
 */
public class JsonSerializer implements Serializer {
    /**
     * 序列化对象为字符串
     * @param obj 对象
     * @return 字符串
     */
    @Override
    public String serialize(Object obj) {
        return JSON.toJSONString(obj, HibernateValueFilter.INSTANCE);
    }
}
