package cn.coufran.springboot.starter.log.logger;

import org.slf4j.LoggerFactory;

/**
 * 基于SLF4J的日志记录器
 * @author Coufran
 * @version 1.0.0
 * @since 1.0.0
 */
public class SlfLogger implements Logger {
    /** SLF4J实例 */
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(Logger.class);

    /**
     * 是否允许error级别的日志
     * @return 允许返回true
     */
    @Override
    public boolean isErrorEnabled() {
        return LOGGER.isErrorEnabled();
    }

    /**
     * 是否允许warn级别的日志
     * @return 允许返回true
     */
    @Override
    public boolean isWarnEnabled() {
        return LOGGER.isWarnEnabled();
    }

    /**
     * 是否允许info级别的日志
     * @return 允许返回true
     */
    @Override
    public boolean isInfoEnabled() {
        return LOGGER.isInfoEnabled();
    }

    /**
     * 是否允许debug级别的日志
     * @return 允许返回true
     */
    @Override
    public boolean isDebugEnabled() {
        return LOGGER.isDebugEnabled();
    }

    /**
     * 是否允许trace级别的日志
     * @return 允许返回true
     */
    @Override
    public boolean isTraceEnabled() {
        return LOGGER.isTraceEnabled();
    }

    /**
     * 输出error级别的日志
     * @param format 日志模版
     * @param arguments 插值
     */
    @Override
    public void error(String format, Object... arguments) {
        LOGGER.error(format, arguments);
    }

    /**
     * 输出warn级别的日志
     * @param format 日志模版
     * @param arguments 插值
     */
    @Override
    public void warn(String format, Object... arguments) {
        LOGGER.warn(format, arguments);
    }

    /**
     * 输出info级别的日志
     * @param format 日志模版
     * @param arguments 插值
     */
    @Override
    public void info(String format, Object... arguments) {
        LOGGER.info(format, arguments);
    }

    /**
     * 输出debug级别的日志
     * @param format 日志模版
     * @param arguments 插值
     */
    @Override
    public void debug(String format, Object... arguments) {
        LOGGER.debug(format, arguments);
    }

    /**
     * 输出trace级别的日志
     * @param format 日志模版
     * @param arguments 插值
     */
    @Override
    public void trace(String format, Object... arguments) {
        LOGGER.trace(format, arguments);
    }

    /**
     * 输出error级别的异常日志
     * @param msg 日志消息
     * @param e 异常
     */
    @Override
    public void error(String msg, Throwable e) {
        LOGGER.error(msg, e);
    }

    /**
     * 输出warn级别的异常日志
     * @param msg 日志消息
     * @param e 异常
     */
    @Override
    public void warn(String msg, Throwable e) {
        LOGGER.warn(msg, e);
    }

    /**
     * 输出info级别的异常日志
     * @param msg 日志消息
     * @param e 异常
     */
    @Override
    public void info(String msg, Throwable e) {
        LOGGER.info(msg, e);
    }

    /**
     * 输出debug级别的异常日志
     * @param msg 日志消息
     * @param e 异常
     */
    @Override
    public void debug(String msg, Throwable e) {
        LOGGER.debug(msg, e);
    }

    /**
     * 输出trace级别的异常日志
     * @param msg 日志消息
     * @param e 异常
     */
    @Override
    public void trace(String msg, Throwable e) {
        LOGGER.trace(msg, e);
    }
}
