package cn.coufran.springboot.starter.log;

import cn.coufran.commons.exception.ServiceException;
import cn.coufran.springboot.starter.log.logger.LoggerConfig;
import cn.coufran.springboot.starter.log.serializer.SerializerConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.util.Arrays;
import java.util.Collection;

/**
 * 全局配置类
 * @author Coufran
 * @version 1.0.0
 * @since 1.0.0
 */
@Configuration
@Import({
        AutoLogAdvice.class,
        LoggerConfig.class,
        SerializerConfig.class
})
public class Config {
    /**
     * 配置默认的业务异常类
     * @return 业务异常类
     */
    @Bean
    @ConditionalOnMissingBean
    public Collection<Class<? extends RuntimeException>> serviceExceptionClasses() {
        return Arrays.asList(ServiceException.class);
    }
}
