package cn.coufran.springboot.starter.log;

import org.slf4j.event.Level;

import java.lang.annotation.*;

/**
 * 日志标记
 * @author Coufran
 * @version 1.0.0
 * @since 1.0.0
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE, ElementType.PARAMETER})
public @interface AutoLog {
    /**
     * 定义日志级别，默认{@link Level#INFO INFO}
     * @return 日志级别
     */
    Level level() default Level.INFO;

    /**
     * 定义序列化方式，默认{@link Mode#JSON JSON}
     * @return 序列化方式
     */
    Mode mode() default Mode.JSON;
}
