/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.json;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateUtils.class);
    private static Method isInitializedMethod;

    public static boolean isInitialized(Object proxy) {
        if (isInitializedMethod != null) {
            try {
                return (Boolean)isInitializedMethod.invoke(null, proxy);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("method org.hibernate.Hibernate.isInitialized(Object) error", (Throwable)e);
                return true;
            }
        }
        return true;
    }

    static {
        try {
            Class<?> hibernateClass = Class.forName("org.hibernate.Hibernate");
            isInitializedMethod = hibernateClass.getMethod("isInitialized", Object.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOGGER.warn("could not find method org.hibernate.Hibernate.isInitialized(Object)");
            isInitializedMethod = null;
        }
    }
}

