package cn.coufran.springboot.starter.json;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * 配置类
 * @author Coufran
 * @version 1.0.0
 * @since 1.0.0
 */
@AutoConfiguration
public class Config {
    /**
     * HibernateValueFilter，解决Hibernate Lazy load无法序列化问题
     * @return HibernateValueFilter
     */
    @Bean
    @ConditionalOnMissingBean
    public HibernateValueFilter hibernateValueFilter() {
        return HibernateValueFilter.INSTANCE;
    }
}
