/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.json;

import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.util.TypeUtils;
import java.util.Collection;
import java.util.TreeSet;

public class HibernateValueFilter
implements ValueFilter {
    private static Collection<String> proxyClassNames = new TreeSet<String>();
    private static Collection<String> proxyInterfaceNames = new TreeSet<String>();

    public static void addProxyClassName(String proxyClassName) {
        proxyClassNames.add(proxyClassName);
    }

    public static void addProxyInterfaceName(String proxyInterfaceName) {
        proxyInterfaceNames.add(proxyInterfaceName);
    }

    public Object process(Object object, String name, Object value) {
        if (value != null && this.isProxy(value.getClass()) && !TypeUtils.isHibernateInitialized((Object)value)) {
            return null;
        }
        return value;
    }

    private boolean isProxy(Class<?> clazz) {
        String className;
        if (!proxyClassNames.isEmpty() && proxyClassNames.contains(className = clazz.getName())) {
            return true;
        }
        if (!proxyInterfaceNames.isEmpty()) {
            Class<?>[] interfaces;
            for (Class<?> interface_ : interfaces = clazz.getInterfaces()) {
                String interfaceName = interface_.getName();
                if (!proxyInterfaceNames.contains(interfaceName)) continue;
                return true;
            }
        }
        return TypeUtils.isProxy(clazz);
    }

    static {
        HibernateValueFilter.addProxyClassName("org.hibernate.collection.internal.PersistentBag");
    }
}

