package cn.coufran.springboot.starter.http.content;

import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;

import java.nio.charset.StandardCharsets;

/**
 * @author Coufran
 * @version 2.0.0
 * @since 2.0.0
 */
public class TextContent extends HttpBodyContent<String> implements HttpRequestBodyContent, HttpResponseBodyContent {
    private String content;

    public TextContent(String content) {
        this.content = content;
    }

    public TextContent(String name, String content) {
        super(name);
        this.content = content;
    }

    @Override
    public String content() {
        return content;
    }

    @Override
    public MultipartEntityBuilder accept(MultipartEntityBuilder entityBuilder) {
        return entityBuilder.addTextBody(this.name(), this.content());
    }

    @Override
    public EntityBuilder accept(EntityBuilder entityBuilder) {
        return entityBuilder.setText(this.content());
    }

    @Override
    public byte[] asBytes() {
        return content().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String asString() {
        return content();
    }

    @Override
    public String toString() {
        return "TextContent{" +
                "content='" + content + '\'' +
                "} " + super.toString();
    }
}
