package cn.coufran.springboot.starter.http.content;

import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;

import java.io.InputStream;

/**
 * @author Coufran
 * @version 2.0.0
 * @since 2.0.0
 */
public class StreamContent extends HttpBodyContent<InputStream> implements HttpRequestBodyContent {
    private InputStream content;

    public StreamContent(String name, InputStream content) {
        super(name);
        this.content = content;
    }

    public StreamContent(InputStream content) {
        this.content = content;
    }

    @Override
    public InputStream content() {
        return this.content;
    }

    @Override
    public MultipartEntityBuilder accept(MultipartEntityBuilder entityBuilder) {
        return entityBuilder.addBinaryBody(this.name(), this.content());
    }

    @Override
    public EntityBuilder accept(EntityBuilder entityBuilder) {
        return entityBuilder.setStream(this.content());
    }

    @Override
    public String toString() {
        return "StreamContent{" +
                "content=" + content +
                "} " + super.toString();
    }
}
