package cn.coufran.springboot.starter.http.content;

import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;

import java.io.File;

/**
 * @author Coufran
 * @version 2.0.0
 * @since 2.0.0
 */
public class FileContent extends HttpBodyContent<File> implements HttpRequestBodyContent {
    private File content;

    public FileContent(String name, File content) {
        super(name);
        this.content = content;
    }

    public FileContent(File content) {
        this.content = content;
    }

    @Override
    public File content() {
        return this.content;
    }

    @Override
    public MultipartEntityBuilder accept(MultipartEntityBuilder entityBuilder) {
        return entityBuilder.addBinaryBody(this.name(), this.content());
    }

    @Override
    public EntityBuilder accept(EntityBuilder entityBuilder) {
        return entityBuilder.setFile(this.content());
    }

    @Override
    public String toString() {
        return "FileContent{" +
                "content=" + content +
                "} " + super.toString();
    }
}
