package cn.coufran.springboot.starter.http.content;

import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;

import java.nio.charset.StandardCharsets;

/**
 * @author Coufran
 * @version 2.0.0
 * @since 2.0.0
 */
public class BinaryContent extends HttpBodyContent<byte[]> implements HttpRequestBodyContent, HttpResponseBodyContent {
    private byte[] content;

    public BinaryContent(String name, byte[] content) {
        super(name);
        this.content = content;
    }

    public BinaryContent(byte[] content) {
        this.content = content;
    }

    @Override
    public byte[] content() {
        return this.content;
    }

    @Override
    public MultipartEntityBuilder accept(MultipartEntityBuilder entityBuilder) {
        return entityBuilder.addBinaryBody(this.name(), this.content());
    }

    @Override
    public EntityBuilder accept(EntityBuilder entityBuilder) {
        return entityBuilder.setBinary(this.content());
    }

    @Override
    public byte[] asBytes() {
        return content();
    }

    @Override
    public String asString() {
        return new String(content(), StandardCharsets.UTF_8);
    }

    @Override
    public String toString() {
        return "BinaryContent{" +
                "content.length=" + content == null ? null : content.length +
                "} " + super.toString();
    }
}
