package cn.coufran.springboot.starter.http;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * starter配置
 * @author Coufran
 * @version 1.0.0
 * @since 1.0.0
 */
@Configuration
public class Config {
    /**
     * 默认Http客户端
     * @return HttpClient
     */
    @Bean
    @ConditionalOnMissingBean
    public HttpClient httpClient() {
        return HttpClient.INSTANCE_DEFAULT;
    }
}
