/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.impl.token.config;

import cn.coufran.springboot.starter.auth.AuthUser;
import cn.coufran.springboot.starter.auth.AuthUserManager;
import cn.coufran.springboot.starter.auth.impl.token.FileKeyStore;
import cn.coufran.springboot.starter.auth.impl.token.JjwtTokenRegister;
import cn.coufran.springboot.starter.auth.impl.token.KeyStore;
import cn.coufran.springboot.starter.auth.impl.token.LocalMapRefreshTokenRepository;
import cn.coufran.springboot.starter.auth.impl.token.PojoJsonTokenPayloadConverter;
import cn.coufran.springboot.starter.auth.impl.token.RefreshTokenRepository;
import cn.coufran.springboot.starter.auth.impl.token.TokenAuthUserManager;
import cn.coufran.springboot.starter.auth.impl.token.TokenCertificate;
import cn.coufran.springboot.starter.auth.impl.token.TokenPayloadConverter;
import cn.coufran.springboot.starter.auth.impl.token.TokenRegister;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;
import org.springframework.web.context.annotation.RequestScope;

public class TokenAuthConfig {
    @Bean
    @ConditionalOnMissingBean(value={KeyStore.class})
    public KeyStore keyStore(@Value(value="${coufran.auth.token.key:}") String keyPath) {
        if (StringUtils.hasText((String)keyPath)) {
            return new FileKeyStore(keyPath);
        }
        return new FileKeyStore();
    }

    @Bean
    @ConditionalOnMissingBean(value={TokenRegister.class})
    public TokenRegister tokenRegister(KeyStore keyStore) {
        byte[] key = keyStore.load();
        if (key != null) {
            return new JjwtTokenRegister(key);
        }
        JjwtTokenRegister tokenRegister = new JjwtTokenRegister();
        key = tokenRegister.getKey();
        keyStore.save(key);
        return tokenRegister;
    }

    @Bean
    @ConditionalOnMissingBean(name={"tokenPayloadConverters"})
    public List<TokenPayloadConverter<?>> tokenPayloadConverters() {
        ArrayList tokenPayloadConverters = new ArrayList(1);
        tokenPayloadConverters.add(new PojoJsonTokenPayloadConverter());
        return tokenPayloadConverters;
    }

    @Bean
    @ConditionalOnMissingBean(value={RefreshTokenRepository.class})
    public RefreshTokenRepository refreshTokenRepository() {
        return new LocalMapRefreshTokenRepository();
    }

    @Bean
    public AuthUserManager authUserManager(TokenRegister tokenRegister, List<TokenPayloadConverter<?>> tokenPayloadConverters, RefreshTokenRepository refreshTokenRepository) {
        return new TokenAuthUserManager(tokenRegister, tokenPayloadConverters, refreshTokenRepository);
    }

    @Bean
    @RequestScope
    public <U> AuthUser<U> authUser(HttpServletRequest request, AuthUserManager authUserManager) {
        String token = request.getHeader("Token");
        return authUserManager.getAuthUser(new TokenCertificate(token));
    }
}

