/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.impl.token;

import cn.coufran.commons.exception.ServiceException;
import cn.coufran.springboot.starter.auth.impl.token.TokenRegister;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JjwtTokenRegister
implements TokenRegister {
    private static final String ALGORITHM = "HmacSHA256";
    public static final String CLAIM_KEY_DATA = "data";
    private final SecretKey KEY;

    public JjwtTokenRegister() {
        try {
            this.KEY = KeyGenerator.getInstance(ALGORITHM).generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JjwtTokenRegister(byte[] key) {
        this.KEY = new SecretKeySpec(key, ALGORITHM);
    }

    public byte[] getKey() {
        return this.KEY.getEncoded();
    }

    @Override
    public String generate(String payload, int expireTime) {
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put(CLAIM_KEY_DATA, payload);
        Date now = new Date();
        return Jwts.builder().claims(claims).issuedAt(now).expiration(new Date(now.getTime() + (long)expireTime * 60L * 1000L)).id(UUID.randomUUID().toString()).signWith((Key)this.KEY).compact();
    }

    @Override
    public String parse(String token) {
        try {
            return (String)((Claims)Jwts.parser().verifyWith(this.KEY).build().parseSignedClaims((CharSequence)token).getPayload()).get(CLAIM_KEY_DATA, String.class);
        }
        catch (JwtException e) {
            return null;
        }
    }
}

