/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth;

import cn.coufran.springboot.starter.auth.AuthUser;
import cn.coufran.springboot.starter.auth.AuthUserManager;
import cn.coufran.springboot.starter.auth.Certificate;

public abstract class AbstractAuthUser<D>
implements AuthUser<D> {
    private AuthUserManager authUserManager;
    private boolean authenticated;
    private D data;

    public AbstractAuthUser(AuthUserManager authUserManager) {
        this(authUserManager, false, null);
    }

    public AbstractAuthUser(AuthUserManager authUserManager, D data) {
        this(authUserManager, true, data);
    }

    public AbstractAuthUser(AuthUserManager authUserManager, boolean authenticated, D data) {
        this.authUserManager = authUserManager;
        this.authenticated = authenticated;
        this.data = data;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public D getData() {
        return this.data;
    }

    @Override
    public Certificate login(D data) {
        Certificate certificate = this.authUserManager.acceptLogin(this, data);
        this.authenticated = true;
        this.data = data;
        return certificate;
    }

    @Override
    public Certificate refresh() {
        return this.authUserManager.acceptRefresh(this);
    }

    @Override
    public void logout() {
        this.authUserManager.acceptLogout(this);
        this.authenticated = false;
        this.data = null;
    }
}

