/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.impl.token;

import cn.coufran.commons.exception.ServiceException;
import cn.coufran.springboot.starter.auth.AuthUser;
import cn.coufran.springboot.starter.auth.AuthUserManager;
import cn.coufran.springboot.starter.auth.Certificate;
import cn.coufran.springboot.starter.auth.impl.token.RefreshTokenRepository;
import cn.coufran.springboot.starter.auth.impl.token.TokenAuthUser;
import cn.coufran.springboot.starter.auth.impl.token.TokenCertificate;
import cn.coufran.springboot.starter.auth.impl.token.TokenPayloadConverter;
import cn.coufran.springboot.starter.auth.impl.token.TokenRegister;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.util.Date;
import java.util.List;

public class TokenAuthUserManager
implements AuthUserManager {
    private static final int EXPIRE_TIME_DEFAULT = 7200;
    private static final int REFRESH_EXPIRE_TIME_DEFAULT = 172800;
    private static final String PAYLOAD_KEY_DATA = "d";
    private static final String PAYLOAD_KEY_CONVERTER = "c";
    private static final String PAYLOAD_KEY_TYPE = "t";
    private TokenRegister tokenRegister;
    private List<TokenPayloadConverter<?>> tokenPayloadConverters;
    private RefreshTokenRepository refreshTokenRepository;

    public TokenAuthUserManager(TokenRegister tokenRegister, List<TokenPayloadConverter<?>> tokenPayloadConverters, RefreshTokenRepository refreshTokenRepository) {
        this.tokenRegister = tokenRegister;
        this.tokenPayloadConverters = tokenPayloadConverters;
        this.refreshTokenRepository = refreshTokenRepository;
    }

    @Override
    public <D> AuthUser<D> reloadAuthenticated(Certificate certificate) {
        if (!(certificate instanceof TokenCertificate)) {
            return null;
        }
        TokenCertificate tokenCertificate = (TokenCertificate)certificate;
        String token = tokenCertificate.getAccessToken();
        if (token == null) {
            return null;
        }
        String payload = this.tokenRegister.parse(token);
        if (payload == null) {
            return null;
        }
        JSONObject payloadJson = JSON.parseObject((String)payload);
        Object data = null;
        String convertorName = payloadJson.getString(PAYLOAD_KEY_CONVERTER);
        for (TokenPayloadConverter<?> tokenPayloadConverter : this.tokenPayloadConverters) {
            if (!convertorName.equals(tokenPayloadConverter.getName())) continue;
            String dataPayload = payloadJson.getString(PAYLOAD_KEY_DATA);
            data = tokenPayloadConverter.deserialize(dataPayload);
            break;
        }
        if (data == null) {
            return null;
        }
        TokenAuthUser.Auth auth = (TokenAuthUser.Auth)((Object)payloadJson.getObject(PAYLOAD_KEY_TYPE, TokenAuthUser.Auth.class, new JSONReader.Feature[0]));
        return new TokenAuthUser<Object>(this, data, auth, token);
    }

    @Override
    public <D> AuthUser<D> createAnonymous() {
        return new TokenAuthUser(this);
    }

    @Override
    public <D> Certificate acceptLogin(AuthUser<D> authUser, D data) {
        JSONObject payloadJson = new JSONObject();
        for (TokenPayloadConverter<?> tokenPayloadConverter : this.tokenPayloadConverters) {
            if (!tokenPayloadConverter.support(data)) continue;
            String dataPayload = tokenPayloadConverter.serialize(data);
            payloadJson.put((Object)PAYLOAD_KEY_DATA, (Object)dataPayload);
            payloadJson.put((Object)PAYLOAD_KEY_CONVERTER, (Object)tokenPayloadConverter.getName());
            break;
        }
        if (payloadJson.isEmpty()) {
            throw new ServiceException("not supported data: " + data);
        }
        return this.generateCertificate(payloadJson);
    }

    @Override
    public <D> Certificate acceptRefresh(AuthUser<D> authUser) {
        TokenAuthUser tokenAuthUser = (TokenAuthUser)authUser;
        if (tokenAuthUser.getAuth() != TokenAuthUser.Auth.REFRESH) {
            throw new ServiceException("\u65e0\u6743\u9650");
        }
        String token = tokenAuthUser.getToken();
        boolean exists = this.refreshTokenRepository.delete(token);
        if (!exists) {
            throw new ServiceException("\u65e0\u6743\u9650");
        }
        return this.acceptLogin(authUser, authUser.getData());
    }

    private TokenCertificate generateCertificate(JSONObject payloadJson) {
        payloadJson.put((Object)PAYLOAD_KEY_TYPE, (Object)TokenAuthUser.Auth.ACCESS);
        String accessToken = this.tokenRegister.generate(payloadJson.toJSONString(new JSONWriter.Feature[0]), 7200);
        payloadJson.put((Object)PAYLOAD_KEY_TYPE, (Object)TokenAuthUser.Auth.REFRESH);
        String refreshToken = this.tokenRegister.generate(payloadJson.toJSONString(new JSONWriter.Feature[0]), 172800);
        Date expireTime = new Date(System.currentTimeMillis() + 172800000L);
        this.refreshTokenRepository.save(refreshToken, expireTime);
        return new TokenCertificate(accessToken, 7200, refreshToken, 172800);
    }

    @Override
    public <U> void acceptLogout(AuthUser<U> authUser) {
    }
}

