/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.impl.token;

import cn.coufran.springboot.starter.auth.impl.token.KeyStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileKeyStore
implements KeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileKeyStore.class);
    private static final String FILE_NAME_KEY = "default.key";
    private String fileName;

    public FileKeyStore() {
        this(FILE_NAME_KEY);
    }

    public FileKeyStore(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void save(byte[] key) {
        boolean mkdirSuccess;
        Path keyFile = Paths.get(this.fileName, new String[0]);
        File keyFileDir = keyFile.toFile().getAbsoluteFile().getParentFile();
        if (!keyFileDir.exists() && !(mkdirSuccess = keyFileDir.mkdirs())) {
            LOGGER.error("save key error, mkdir fail: {}", (Object)keyFileDir.getParent());
        }
        try {
            Files.write(keyFile, key, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("save key fail, {}", (Object)e.getMessage());
            LOGGER.info("save key fail", (Throwable)e);
        }
    }

    @Override
    public byte[] load() {
        Path keyFile = Paths.get(this.fileName, new String[0]);
        if (!Files.exists(keyFile, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.readAllBytes(keyFile);
        }
        catch (IOException e) {
            LOGGER.error("read key fail, {}", (Object)e.getMessage());
            LOGGER.info("read key fail", (Throwable)e);
            return null;
        }
    }
}

