/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.config;

import cn.coufran.springboot.starter.auth.AuthUser;
import cn.coufran.springboot.starter.auth.config.AuthAddition;
import cn.coufran.springboot.starter.auth.config.AuthInterceptor;
import cn.coufran.springboot.starter.auth.config.SpringWebMvcConfig;
import cn.coufran.springboot.starter.auth.impl.simple.SimpleAuthUser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.context.annotation.RequestScope;

@Configuration
@Import(value={SpringWebMvcConfig.class})
public class AuthConfig {
    @Value(value="${coufran.auth.whitePath:}")
    private List<String> whitePaths;
    @Autowired(required=false)
    private List<AuthAddition> authAdditions = new ArrayList<AuthAddition>();

    @Bean
    @RequestScope
    @ConditionalOnMissingBean(value={AuthUser.class})
    public AuthUser authUser() {
        return new SimpleAuthUser();
    }

    @Bean
    public AuthInterceptor authInterceptor(AuthUser authUser) {
        AuthInterceptor authInterceptor = new AuthInterceptor(authUser);
        authInterceptor.setWhitePaths(this.whitePaths);
        authInterceptor.setAuthAdditions(this.authAdditions);
        return authInterceptor;
    }
}

