/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.impl.token;

import cn.coufran.springboot.starter.auth.impl.token.TokenPayloadConverter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PojoJsonTokenPayloadConverter
implements TokenPayloadConverter<Object> {
    private static final Pattern PATTERN_PAYLOAD = Pattern.compile("(.+)\\|(.+)");

    @Override
    public String getName() {
        return "PojoJson";
    }

    @Override
    public boolean support(Object data) {
        return true;
    }

    @Override
    public String serialize(Object data) {
        String dataJson = JSON.toJSONString((Object)data);
        String className = data.getClass().getName();
        return className + "|" + dataJson;
    }

    @Override
    public <D> D deserialize(String payload) {
        Class<?> dataClass;
        Matcher payloadMatcher = PATTERN_PAYLOAD.matcher(payload);
        if (!payloadMatcher.matches()) {
            return null;
        }
        try {
            String className = payloadMatcher.group(1);
            dataClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        String dataJson = payloadMatcher.group(2);
        try {
            return (D)JSON.parseObject((String)dataJson, dataClass);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

