/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.impl.token;

import cn.coufran.springboot.starter.auth.impl.token.RefreshTokenRepository;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LocalMapRefreshTokenRepository
implements RefreshTokenRepository {
    private volatile Map<String, Date> refreshTokens = new ConcurrentHashMap<String, Date>();
    private volatile int lastCleanSize = 0;

    @Override
    public void save(String refreshToken, Date expireTime) {
        this.clean();
        this.refreshTokens.put(refreshToken, expireTime);
    }

    @Override
    public boolean delete(String refreshToken) {
        Date expireTime = this.refreshTokens.remove(refreshToken);
        if (expireTime == null) {
            return false;
        }
        return System.currentTimeMillis() <= expireTime.getTime();
    }

    private void clean() {
        if (this.refreshTokens.size() < this.lastCleanSize * 2 + 1) {
            return;
        }
        long now = System.currentTimeMillis();
        Set<String> refreshTokenKeySet = this.refreshTokens.keySet();
        for (String refreshToken : refreshTokenKeySet) {
            Date expireTime = this.refreshTokens.get(refreshToken);
            if (expireTime == null || expireTime.getTime() >= now) continue;
            this.refreshTokens.remove(refreshToken);
        }
        this.lastCleanSize = this.refreshTokens.size();
    }
}

