/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.impl.token;

import cn.coufran.springboot.starter.api.exception.ServiceException;
import cn.coufran.springboot.starter.auth.impl.token.TokenRegister;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JjwtTokenRegister
implements TokenRegister {
    private SecretKey KEY;

    public JjwtTokenRegister() {
        try {
            this.KEY = KeyGenerator.getInstance("HmacSHA256").generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JjwtTokenRegister(byte[] key) {
        this.KEY = new SecretKeySpec(key, "HmacSHA256");
    }

    public byte[] getKey() {
        return this.KEY.getEncoded();
    }

    @Override
    public String generate(String payload, int expireTime) {
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("data", payload);
        Date now = new Date();
        return Jwts.builder().setClaims(claims).setIssuedAt(now).setExpiration(new Date(now.getTime() + (long)(expireTime * 60 * 1000))).setId(UUID.randomUUID().toString()).signWith(SignatureAlgorithm.HS256, (Key)this.KEY).compact();
    }

    @Override
    public String parse(String token) {
        try {
            return (String)((Claims)Jwts.parser().setSigningKey((Key)this.KEY).parseClaimsJws(token).getBody()).get("data", String.class);
        }
        catch (JwtException e) {
            return null;
        }
    }
}

