/*
 * Decompiled with CFR 0.152.
 */
package cn.coufran.springboot.starter.auth.impl.session;

import cn.coufran.springboot.starter.auth.AuthUser;
import cn.coufran.springboot.starter.auth.AuthUserManager;
import cn.coufran.springboot.starter.auth.Certificate;
import cn.coufran.springboot.starter.auth.impl.session.SessionAuthUser;
import cn.coufran.springboot.starter.auth.impl.session.SessionCertificate;
import javax.servlet.http.HttpSession;

public class SessionAuthUserManager
implements AuthUserManager {
    private static final String ATTRIBUTE_NAME_AUTH = "auth";
    private HttpSession session;

    public SessionAuthUserManager(HttpSession session) {
        this.session = session;
    }

    @Override
    public <D> AuthUser<D> reloadAuthenticated(Certificate certificate) {
        Object data = this.session.getAttribute(ATTRIBUTE_NAME_AUTH);
        if (data == null) {
            return null;
        }
        return new SessionAuthUser<Object>(this, data);
    }

    @Override
    public <D> AuthUser<D> createAnonymous() {
        return new SessionAuthUser(this);
    }

    public <U> Certificate acceptLogin(AuthUser<U> authUser, U data) {
        this.session.setAttribute(ATTRIBUTE_NAME_AUTH, data);
        return new SessionCertificate();
    }

    @Override
    public <D> Certificate acceptRefresh(AuthUser<D> authUser) {
        return new SessionCertificate();
    }

    @Override
    public <U> void acceptLogout(AuthUser<U> authUser) {
        this.session.removeAttribute(ATTRIBUTE_NAME_AUTH);
    }
}

